#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include "gamestate.h"
#include "tcp.h"
#include "buffered_tcp.h"

#define TRUE 1
#define FALSE 0
#define MEGABYTE (1024*1024)
int serverSock;
TcpBuffer *clientSock[MAX_PLAYERS];
int numPlayers;
int port;

//----------------------
// We can't use glut timer, because
//  we're not using glut for the deticated server
//----------------------
void UpdateFramerate();
double SysTime();
double startTime;
double currTime;
double spf;  // seconds per frame


//----------------------
// My opionion is what counts...I'm the server
//  "myGameState" is the law.  I don't
//  care if "myGameState" is truth or laggy fiction...
//  "myGameState" is the law.
//----------------------
GameState   myGameState;

int main(int argc, char **argv) {

	int i;
	double lastSendTime=0.0;

	//-----------------
	// Check the command arguments
	//-----------------
	if (argc != 3)  {
		printf("ERROR: please call in format:\n");
		printf("   ./aster_server numPlayers port");
		printf("\n");
		printf("      (for example tut_server  2 7777 starts a two player deticated server on port 7777)\n");
		exit(1);
	}
	numPlayers = atoi(argv[1]);
	port       = atoi(argv[2]);
	if (numPlayers > MAX_PLAYERS) {
		printf("ERROR: cannot accept %d players (limit %d)\n", numPlayers, MAX_PLAYERS);
		exit(1);
	}
	
	// Wait for clients to connect
	serverSock = TcpServerEstablish(port);
	for (i=0; i<numPlayers; i++) {
		clientSock[i] = BufferedTcpServerAcceptClient(serverSock, MEGABYTE);
		printf("  Player %d of %d has connected !!!\n", i+1, numPlayers);
	}

	// Tell clients which player they are (and how many players)
	for (i=0; i<numPlayers; i++) {
		BufferedTcpSend(clientSock[i], &numPlayers, sizeof(int));
		BufferedTcpSend(clientSock[i], &i, sizeof(int));
	}

	// Allright all the clients (players) are connected
	//  Let's Start the Game !!
	int levelNumAsteroids = 1;
	NewGameState(&myGameState, levelNumAsteroids, numPlayers);
	startTime = SysTime();
	currTime  = SysTime();

	// Main Server Loop
	while (1) {

		//-------------------
		// Read Client Data Packets
		//-------------------
		for (i=0; i<numPlayers; i++) {

			// read a packet
			if ( BufferedTcpPeekRecv(clientSock[i], sizeof(Ship)) )
				BufferedTcpRecv(clientSock[i], &(myGameState.players[i].ship), sizeof(Ship));
		}

		//-------------------
		// Update Simulation
		//-------------------
		UpdateFramerate();
		UpdateGameState(&myGameState, spf);
		ArbitrateGameState(&myGameState, spf);

		// Victory Condition?   (more asteroids)
		if (myGameState.numAsteroids == 0) {
			levelNumAsteroids+=3;
			NewGameState(&myGameState, levelNumAsteroids, numPlayers);
		}

		//-------------------
		// Write Out Gamestate TO Clients
		//  but no more than 50 fps
		//-------------------
		if (  (currTime-lastSendTime) > (1.0/50.0)  ) {
			lastSendTime = currTime;
			for (i=0; i<numPlayers; i++)
				BufferedTcpSend(clientSock[i],&myGameState,sizeof(GameState));
			myGameState.numSounds = 0;
		}
		
		//-------------------
		// For numeric stability, server does not update
		//  anything at more thab 5000 fps
		//-------------------
		usleep(200);
	}

	return 0;
}

//-------------------------
//-------------------------
// Performance Timer (we need this)!
//-------------------------
//-------------------------
void UpdateFramerate() {
	double prevTime = currTime;
	currTime = SysTime();
	spf = currTime - prevTime;
}
double SysTime() {    //for profiling
        struct timeval tv;
        double time;
        gettimeofday (&tv, NULL);
        time = (double)((double)tv.tv_usec / 1000000.0);
        time += (double)tv.tv_sec;
        return time;
}


